// EditAccessLevel.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "EditAccessLevel.h"
#include <afxtempl.h>
#define MAXLEN 255

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditAccessLevel dialog

//long m_UserID;

CEditAccessLevel::CEditAccessLevel(CWnd* pParent /*=NULL*/)
	: CDialog(CEditAccessLevel::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditAccessLevel)
	m_AcclName = _T("");
	m_AcclDesc = _T("");
	//}}AFX_DATA_INIT
}

CEditAccessLevel ::CEditAccessLevel(IApplication *pApp):CDialog(CEditAccessLevel::IDD, NULL)
{
	pApplication = pApp;
	pAccl.CreateInstance(__uuidof(AccessLevel));
	
}
void CEditAccessLevel::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditAccessLevel)
	DDX_Control(pDX, IDC_ACCLLIST, m_AcclList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST1, m_SubAcctList);
	DDX_Control(pDX, IDC_EDITACCESS_SUBACCT, m_EditSubAcctList);
	DDX_Control(pDX, IDC_EDITACCESS_DESC, m_Cnt_AcclDesc);
	DDX_Control(pDX, IDC_EDITACCESS_NAME, m_Cnt_AcclName);
	DDX_Text(pDX, IDC_EDITACCESS_NAME, m_AcclName);
	DDX_Text(pDX, IDC_EDITACCESS_DESC, m_AcclDesc);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditAccessLevel, CDialog)
	//{{AFX_MSG_MAP(CEditAccessLevel)
	ON_BN_CLICKED(ID_EDIT, OnEdit)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST1, OnSelchangeSubAcctlist)
	ON_CBN_SELCHANGE(IDC_ACCLLIST, OnSelchangeAccllist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditAccessLevel message handlers
BOOL CEditAccessLevel::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	LoadAccounts();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}
void CEditAccessLevel :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctid;
				sAcctid.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctid);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}

void CEditAccessLevel :: LoadSubAccounts(long lAcctID)
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
		pApplication->GetSubAccountsByAccountID(lAcctID,&vSubAccounts); // get subaccount details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pSubAccount = NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount != NULL)
			{
				m_SubAcctList.AddString(pSubAccount->AccountName);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}

void CEditAccessLevel :: LoadSubAccountNames(long lAcctID)
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
		pApplication->GetSubAccountsByAccountID(lAcctID,&vSubAccounts); // get subaccount details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pSubAccount = NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount != NULL)
			{
				m_EditSubAcctList.AddString(pSubAccount->AccountName);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
		//m_AcctList.SetCurSel(0);
	UpdateData(FALSE);
}

void CEditAccessLevel ::LoadAccessLevels()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

		//select subaccount name 
		int subacct_index = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(subacct_index,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();

		_variant_t vAccls;
		vAccls.Clear();
		pApplication->GetAccessLevelsByAccountName(bstrAcctName,bstrSubAcctName,&vAccls); // get access levels details of particular account  in WP-CS database server
		
		if(vAccls.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccessLevel *pAccl = NULL;
		
		COleSafeArray sa(vAccls);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccessLevel,(void**)&pAccl);
			if (pAccl != NULL)
			{
				m_AcclList.AddString(pAccl->AccessLevelName);
				pAccl->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_AcclList.SetCurSel(0);
}
void CEditAccessLevel :: GetAccessLevelDetails()
{
	//select account name 
		int acct_index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(acct_index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
	//select access level name 
		int index = m_AcclList.GetCurSel();
		CString sAcclName;
		m_AcclList.GetLBText(index,sAcclName);
		BSTR bstrAcclName = sAcclName.AllocSysString();	
		_variant_t vAccl;
		vAccl.Clear();
		pApplication->GetAccessLevelByName(bstrAcclName,bstrAcctName,&vAccl);

		if(vAccl.vt ==  VT_EMPTY)
		{
			return;
		}
		UpdateData(TRUE);
		if( vAccl.vt & VT_DISPATCH)
		{
			
			IAccessLevelPtr paccl(vAccl.pdispVal);
			m_AcclName =CString(((LPWSTR)paccl->AccessLevelName));
			m_AcclDesc =CString(((LPWSTR)paccl->AccessLevelDesc));

			//Subaccounts
			_variant_t vSubAccounts;
			vSubAccounts.Clear();
			paccl->get_SubAccountNames(&vSubAccounts);
			if(vSubAccounts.vt == VT_EMPTY)
			{
				AfxMessageBox(L"No SubAccounts");
				return;
			}
			
			long uBound =0 ;
			CString sSubAccounts;
			
			COleSafeArray sa(vSubAccounts);
			sa.GetUBound(1,&uBound);
			UpdateData(TRUE);
			BSTR bstrSubAccount;
			for(long i =0 ;i <= uBound ; i++)
			{
				sa.GetElement(&i,(void*)&bstrSubAccount);
				CString sSubAccount = CString(bstrSubAccount);
				for(int j=0;j<m_EditSubAcctList.GetCount();j++)
				{
					CString sSubAcctName;
					m_EditSubAcctList.GetText(j,sSubAcctName);
					if(sSubAcctName.CompareNoCase(sSubAccount) == 0)
						m_EditSubAcctList.SetSel(j,TRUE);
				}
			}
		}

		UpdateData(FALSE);
		if(NULL != vAccl.pdispVal)
		{
			//vAccl.pdispVal->Release();
			vAccl.Clear();
		}
}

void CEditAccessLevel::OnEdit()
{
	BSTR bstrAcclName;
	BSTR bstrAcclDesc;
	BSTR bstrAcctName;
	BSTR bstrExAcclName;
	UpdateData(TRUE);
	//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
	//select access level List
		int index_Accl = m_AcclList.GetCurSel();
		CString sAcclName;
		if (index_Accl <0)
			bstrExAcclName = SysAllocString(L"");
		else
		{
			m_AcclList.GetLBText(index_Accl,sAcclName);
			bstrExAcclName = sAcclName.AllocSysString();
		}
//get access level name & Description

	bstrAcclName = m_AcclName.AllocSysString();
	bstrAcclDesc = m_AcclDesc.AllocSysString();
//set access level properties
	pAccl->AccountName = bstrAcctName;
	pAccl->AccessLevelName = bstrAcclName;
	pAccl->AccessLevelDesc = bstrAcclDesc;

	CArray<int,int> SubAcctsels;
	VARIANT vSubAccounts;
	int nSubAcct = m_EditSubAcctList.GetSelCount();
	if (nSubAcct <= 0)
	{
		AfxMessageBox(L"Select SubAccount from the SubAccounts List");
		return;
	}
	COleSafeArray saSubAccounts;
	saSubAccounts.CreateOneDim(VT_BSTR,nSubAcct);
	SubAcctsels.SetSize(nSubAcct);
	m_EditSubAcctList.GetSelItems(nSubAcct, SubAcctsels.GetData());
	for(long j = 0; j < nSubAcct; j++)                                                  
	{                                                      
		CString sSubAcctName;       
		_bstr_t bstrSubAcctName;
		m_EditSubAcctList.GetText(SubAcctsels[j], sSubAcctName);
		bstrSubAcctName = sSubAcctName.AllocSysString();
		saSubAccounts.PutElement(&j,static_cast<BSTR>(bstrSubAcctName));
	}
	vSubAccounts = saSubAccounts.Detach();

	pAccl->SubAccountNames  = vSubAccounts;
	
	long lStatus;
	pApplication->EditAccessLevel(bstrExAcclName,pAccl,&lStatus);
		
		if (lStatus == 105)
		{
			AfxMessageBox(L"InValid Account name");
			return;
		}
		if(lStatus == 201)
		{
			AfxMessageBox(L"InValid Access level name");
			return;
		}
		if (lStatus == 206)
		{
			AfxMessageBox(L"Invalid Accesslevel Name / Description string length");
			return;
		}
		if ( lStatus == 202)
		{
			AfxMessageBox(L"AccessLevel Name Exists");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"AccessLevel Edit Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Access level Edit succeded");
			CDialog::OnOK();
		}

	UpdateData(FALSE);
}

void CEditAccessLevel::OnSelchangeAcctlist() 
{
	int index_Acct = m_AcctList.GetCurSel();
	CString sAcctid;

	m_AcctList.GetLBText(index_Acct,sAcctid);
	long lAccountID = _wtoi(sAcctid);

	/*m_Cnt_AcclName.SetWindowText("");
	m_Cnt_AcclDesc.SetWindowText("");
	m_AcclList.ResetContent();
	LoadAccessLevels();*/

	m_SubAcctList.ResetContent();
	LoadSubAccounts(lAccountID);
	LoadSubAccountNames(lAccountID);
	
}

void CEditAccessLevel::OnSelchangeSubAcctlist() 
{
	m_Cnt_AcclName.SetWindowText(L"");
	m_Cnt_AcclDesc.SetWindowText(L"");
	m_AcclList.ResetContent();
	LoadAccessLevels();
	
}

void CEditAccessLevel::OnSelchangeAccllist() 
{
	m_Cnt_AcclName.SetWindowText(L"");
	m_Cnt_AcclDesc.SetWindowText(L"");
	GetAccessLevelDetails();
	m_Cnt_AcclName.SetFocus();
	m_Cnt_AcclName.SetSel(0,-1);
}
